% [X,F,R] = Olincg(A,b,x0[,tol,maxit])
% Solution of a positive-definite linear system by conjugate gradients
%
% Solves A*x = b by minimising the quadratic function f(x) = x'*A*x - b'*x.
%
% Reference: p. 111ff in:
%   Nocedal and Wright: "Numerical Optimization", Springer, 1999.
%
% In:
%   A: n x n positive definite matrix.
%   b: n x 1 vector.
%   x0: n x 1 vector, the starting point.
%   tol: tolerance to stop iterating (minimum gradient norm). Default: 1e-6.
%   maxit: maximum number of iterations. Default: n.
% Out:
%   X: ? x n list of iterates.
%   F: ? x 1 list of the function value at the iterates.
%   R: ? x 1 list of the residual value at the iterates.
%
% Any non-mandatory argument can be given the value [] to force it to take
% its default value.

function [X,F,R] = Olincg(A,b,x0,tol,maxit)

