% Driver file for constrained optimisation with the quadratic-penalty method.
% Sets up the problem (objective function, constraints, etc.), then calls
% Oqpenalty and plots/tabulates results.

range = [-2 2;-1 3];			% Range to plot the functions

% Parameters for the functions
A1 = [-2 0.5;0.5 1]; b1 = [1;-0.3]; c1 = 0;
A2 = -eye(2); b2 = [0;0]; c2 = 0.25;
A3 = [0 0;0 0]; b3 = [1;-2]; c3 = 0;  

% Objective function and equality and inequality constraints
f = @Fquad; paramf = {A1,b1,c1};
E = {@Fquad}; paramE = {{A2,b2,c2}};
I = {@Fquad}; paramI = {{A3,b3,c3}};

% Unconstrained optimisation method and its parameters.
% In paramO do not include x0, tol, maxit (they are set by Oqpenalty).
O = @Onewtoncg; paramO = {'linear'};
% $$$ O = @Osteepdesc; paramO = {};

% Parameters for Oqpenalty
x0 = [1.5;2.4];				% Starting point for Oqpenalty
% $$$ x0 = [-1;-1];
mu0 = 1;				% Starting penalty parameter
tol = [];				% Convergence tolerance
maxit = 50;				% Maximum number of iterations

% Quadratic-penalty constrained optimisation
[X,LE,LI,F,CE,CI,MU,ERR,Oit,condH,G] = ...
    Oqpenalty(f,paramf,E,paramE,I,paramI,O,paramO,x0,mu0,tol,maxit);

% Plot sequence of iterates
figure(1); clf; fcontours(f,paramf,E,paramE,I,paramI,range,50); plotseq(X);

% Plot sequence of Q functions for a range of mu
figure(2); range = [-2 2;-1 1];
for i=2:length(MU)
  clf;
  fcontours(@Q,{f,paramf,E,paramE,I,paramI,MU(i)},E,paramE,I,paramI,range,200);
  title(['\mu = ' num2str(MU(i)) ', \lambda_E = [' num2str(LE(i,:))...
         '], \lambda_I = [' num2str(LI(i,:)) ']']);
  plotseq(X); plotseq(X(i,:),'k*');
  pause;
end

