% Sample driver file. It sets up a problem and runs Onewtoncg on it for 3
% different forcing sequences in the Olincg1 convergence criterion.

% Create matrices A, B
rand('state',123); randn('state',123);
n = 1000; A = rand(n,n); A = A*A'; sigma = 1;
l = (1:n)/n; U = gallery('orthog',n); B = U*diag(l)*U';

% Starting point
x0 = 10*randn(n,1);

i = 0;
convcrit = {'linear','superlinear','quadratic'};
for j = 1:length(convcrit)
  c = convcrit{j};
  fprintf('Convergence criterion: %s',c);
  [X,F,cgit] = Onewtoncg(@F6_1b,{A,sigma,B},x0,1e-12,[],c); it = length(F)-1;
  i = i + 1; figure(i); semilogy(0:it,F,'bo-');
  xlabel('iterations'); ylabel('f'); title(c);
  i = i + 1; figure(i); [p,M] = convseq(X,zeros(size(x0))');
  xlabel('log(d_k)'); ylabel('log(d_{k+1})');
  title([c ': p=' num2str(p) ', M=' num2str(M)]);
  i = i + 1; figure(i); plot(0:it,cgit,'bo-');
  xlabel('iterations'); ylabel('CG iterations'); title(c);
  fprintf('. Total %d Newton iterations.\n',it);
end

