% function [f,g,H] = F6_1b(X,A,sigma,B) Function similar to F6_1
%
% Reference: p. 162 (exercise 6.1) and p. 139ff in:
%   Nocedal and Wright: "Numerical Optimization", Springer, 1999.
%
% f(x) = x'*B*x + sigma*(x'*A*x)
%
% In/Out arguments: see Fquad.m or Frosenbrock.m.
%
% In:
%   A: n x n symmetric matrix.
%   sigma: real number.
%   B: n x n symmetric matrix.

% Copyright (c) 2005 by Miguel A. Carreira-Perpinan

function [f,g,H] = F6_1b(X,A,sigma,B)

[N n] = size(X);

t1 = X*A';
t2 = sum(X.*t1,2);

f = sum(X.*(X*B')/2,2) + sigma*(t2/2).^2;

if nargout > 1
  g = X*B' + sigma*repmat(t2,1,n).*t1;
  if nargout > 2
    H = zeros(n,n,N);
    for i=1:N
      H(:,:,i) = B + sigma*(t2(i)*A+2*t1(i,:)'*t1(i,:));
    end
  end
end

