% function [f,g,H] = Fsines(X) Function with many maxima/minima/saddles
%
% f(x) = sin(2x+y) + sin(y)
%
% View its contours as:
%   fcontours(@Fsines,{},{},{},{},{},[-3 3;-3 3],20);
%
% In:
%   X: N x 2 list of row vectors.
% Out:
%   f: N x 1 list of function values.
%   g: N x 2 list of gradient vectors.
%   H: 2 x 2 x N list of Hessian matrices.

% Copyright (c) 2006 by Miguel A. Carreira-Perpinan

function [f,g,H] = Fsines(X)

N = size(X,1); x = X(:,1); y = X(:,2);

s1 = sin(2*x+y); s2 = sin(y.^2); f = s1 + s2;

if nargout > 1
  c1 = cos(2*x+y); c2 = cos(y.^2); g = [2*c1 c1+2*y.*c2];
  if nargout > 2
    H11 = -4*s1; H12 = -2*s1; H22 = -s1+2*(c2-2*y.^2.*s2);
    H = [reshape(H11,1,1,N) reshape(H12,1,1,N);...
         reshape(H12,1,1,N) reshape(H22,1,1,N)];
  end
end

